set more off
pause off

/**********************************************************************
* Cheaper Faster and More than Good Enough: 
Is GPS the New Gold Standard in Land Area Measurement -- SRM

// Syntax for figure construction		

***********************************************************************/

global mlass 	"$et_data/CheaperFaster_Ethiopia.dta"
global zanzi	"$zanzi/CheaperFaster_Zanzibar.dta"
global nigeria	"$nga_data/CheaperFaster_Nigeria.dta"
global all_exp	"all_aggregate.dta"

global table 	/*"$main\Tables & Figures\Descriptives_7.22b.xlsx"*/
putexcel set 	"$table", modify keepcellform
set scheme economist

/*****************************************************
**						Figures						**
******************************************************

Figure 1: Time taken for GPS and CR measurement

Figure 2: Scatter plots of Compass and Rope and GPS, and Compass and Rope and Self-Reported

Figure 3: Scatter plots of relative and absolute bias

Figure 4: GPS and Compass & Rope Outlines
	** Note: Figure 4 is constructed based on private data.
	Therefore, no syntax is reported **	

*****************************************************/


// Figure 1: Time taken for GPS and CR measurement
	
	use "$all_exp", clear
	graph bar (mean) GPStime_min CRtime_min if survey==1 | survey==2, over(level_cr_acres) by(, title(Average Measurement Duration) subtitle(Plot Size Level (CR) & Minutes)) by(survey, total) 		
	
// Figure 2: Scatter plots of Compass and Rope and GPS, and Compass and Rope and Self-Reported

	use "$all_exp", clear

	tw (scatter CR_acres GPS_acres if survey==1, msize(medium)) (function y=x, range(0 6) lc(cranberry) lw(medthick) legend(off)),  title("Ethiopia") note("") plotregion(margin(medlarge)) xtitle(GPS) ytitle("") name(CR_GPS_Ethiopia, replace) 
	tw (scatter CR_acres SR_acres if survey==1, msize(medium))(function y=x, range(0 6) lc(cranberry) lw(medthick) legend(off)), title(" ") note("") plotregion(margin(medlarge)) xtitle(SR) ytitle(CR) name(CR_SR_Ethiopia, replace)
			gr combine CR_GPS_Ethiopia CR_SR_Ethiopia, col(2) ycommon commonsch scheme(economist) imargin(0 0 0 0) name(Ethiopia, replace)

	tw (scatter CR_acres GPS_acres if survey==2, msize(medium)) (function y=x, range(0 3) lc(cranberry) lw(medthick) legend(off)), title("Tanzania") note("") plotregion(margin(medlarge)) xtitle(GPS) ytitle("") name(CR_GPS_Tanzania, replace)  
	tw (scatter CR_acres SR_acres if survey==2, msize(medium)) (function y=x, range(0 3) lc(cranberry) lw(medthick) legend(off)), title(" ") note("") plotregion(margin(medlarge)) xtitle(SR) ytitle(CR) name(CR_SR_Tanzania, replace)  
			gr combine CR_GPS_Tanzania CR_SR_Tanzania, col(2) ycommon commonsch scheme(economist) imargin(0 0 0 0) name(Tanzania, replace)

	tw (scatter CR_acres GPS_acres if survey==3, msize(medium)) (function y=x, range(0 20) lc(cranberry) lw(medthick) legend(off)), title("Nigeria") note("") plotregion(margin(medlarge)) xtitle(GPS) ytitle("") name(CR_GPS_Nigeria, replace) 
	tw (scatter CR_acres SR_acres if survey==3, msize(medium)) (function y=x, range(0 20) lc(cranberry) lw(medthick) legend(off)), title(" ") note("") plotregion(margin(medlarge)) xtitle(SR) ytitle(CR) name(CR_SR_Nigeria, replace)  
			gr combine CR_GPS_Nigeria CR_SR_Nigeria, col(2) ycommon commonsch scheme(economist) imargin(0 0 0 0) name(Nigeria, replace)

			gr combine Ethiopia Tanzania Nigeria, col(1) scheme(economist) graphregion(fcolor(ltbluishgray) ifcolor(ltbluishgray)) plotregion(fcolor(ltbluishgray) ifcolor(ltbluishgray))

// Figure 3: Scatter plots of relative and absolute bias

	use "$all_exp", clear

	//DISTRIBUTION OF PERCENT BIAS	
	scatter per_bias_cr CR_acres if survey==1, msize(medium) title("Ethiopia") note("") plotregion(margin(medlarge)) xtitle("CR(acres)") ytitle("") name(Rel_Ethiopia, replace) 
	scatter per_bias_cr CR_acres if survey==2, msize(medium) title("Tanzania") note("") plotregion(margin(medlarge)) xtitle("CR(acres)") ytitle("") name(Rel_Zanzi, replace) 
	scatter per_bias_cr CR_acres if survey==3, msize(medium) title("Nigeria") note("") plotregion(margin(medlarge)) xtitle("CR(acres)") ytitle("") name(Rel_Nigeria, replace) 
			gr combine Rel_Ethiopia Rel_Zanzi Rel_Nigeria, col(3) ycommon  scheme(economist) title("Plot Size & Relative Bias (%)")graphregion(fcolor(ltbluishgray) ifcolor(ltbluishgray)) plotregion(fcolor(ltbluishgray) ifcolor(ltbluishgray))
	
	//DISTRIBUTION OF ABSOLUTE BIAS		
	scatter bias_cr CR_acres if survey==1, msize(medium) title("Ethiopia") note("") plotregion(margin(medlarge)) xtitle("CR(acres)") ytitle("") name(Ab_Ethiopia, replace) 
	scatter bias_cr CR_acres if survey==2, msize(medium) title("Tanzania") note("") plotregion(margin(medlarge)) xtitle("CR(acres)") ytitle("") name(Ab_Zanzi, replace) 
	scatter bias_cr CR_acres if survey==3, msize(medium) title("Nigeria") note("") plotregion(margin(medlarge)) xtitle("CR(acres)") ytitle("") name(Ab_Nigeria, replace) 
			gr combine Ab_Ethiopia Ab_Zanzi Ab_Nigeria, col(3) ycommon  scheme(economist) title("Plot Size & Absolute Bias (Acres)")graphregion(fcolor(ltbluishgray) ifcolor(ltbluishgray)) plotregion(fcolor(ltbluishgray) ifcolor(ltbluishgray))
	
